import 'dart:developer';

import 'package:amazcart/AppConfig/app_config.dart';
import 'package:amazcart/controller/cancelled_order_controller.dart';
import 'package:amazcart/controller/settings_controller.dart';
import 'package:amazcart/main.dart';
import 'package:amazcart/model/NewModel/Order/OrderData.dart';
import 'package:amazcart/model/NewModel/Order/Package.dart';
import 'package:amazcart/utils/styles.dart';
import 'package:amazcart/view/amazcart_view/account/orders/OrderDetails.dart';
import 'package:amazcart/widgets/amazcart_widget/AppBarWidget.dart';
import 'package:amazcart/widgets/amazcart_widget/custom_loading_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:get/get.dart';
import 'package:amazcart/model/NewModel/Product/ProductType.dart';
import '../../../../../utils/app_utilities.dart';

class MyCancellations extends StatefulWidget {
  @override
  _MyCancellationsState createState() => _MyCancellationsState();
}

class _MyCancellationsState extends State<MyCancellations> {
  final CancelledOrderController cancelledController =
      Get.put(CancelledOrderController());

  final GeneralSettingsController _currencyController =
      Get.put(GeneralSettingsController());

  String deliverStateName(Package package) {
    var deliveryStatus = '';
    package.processes?.forEach((element) {
      if (package.deliveryStatus == element.id) {
        deliveryStatus = element.name ?? '';
      } else if (package.deliveryStatus == 0) {
        deliveryStatus = "";
      }
    });
    return deliveryStatus;
  }

  String orderStatusGet(OrderData order) {
    var orderStatus;

    if (order.isCancelled == 0 &&
        order.isCompleted == 0 &&
        order.isConfirmed == 0 &&
        order.isPaid == 0) {
      orderStatus = 'Pending'.tr;
    } else {
      if (order.isCancelled == 1) {
        orderStatus = "Cancelled".tr;
      } else if (order.isCompleted == 1) {
        orderStatus = 'Completed'.tr;
      } else if (order.isConfirmed == 1) {
        orderStatus = 'Confirmed'.tr;
      } else if (order.isPaid == 1) {
        orderStatus = 'Paid'.tr;
      }
    }
    return orderStatus;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppStyles.appBackgroundColor,
      appBar: AppBarWidget(title: 'Cancelled Orders'.tr),
      body: Obx(
        () {
          if (cancelledController.isAllOrderLoading.value) {
            return Center(
              child: CustomLoadingWidget(),
            );
          } else {
            if (cancelledController.cancelledOrderListModel.value.orders ==
                    null ||
                cancelledController
                        .cancelledOrderListModel.value.orders?.length ==
                    0) {
              return Center(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Icon(
                      FontAwesomeIcons.exclamation,
                      color: AppStyles.pinkColor,
                      size: 25.w,
                    ),
                    SizedBox(
                      height: 10.h,
                    ),
                    Text(
                      'No Cancelled Orders'.tr,
                      textAlign: TextAlign.center,
                      style: AppStyles.kFontPink15w5.copyWith(
                        fontSize: 16.fontSize,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ],
                ),
              );
            }
            return Container(
              child: ListView.separated(
                separatorBuilder: (context, index) {
                  return Divider(
                    color: AppStyles.appBackgroundColor,
                    height: 5.h,
                    thickness: 5,
                  );
                },
                itemCount: cancelledController
                    .cancelledOrderListModel.value.orders!.length,
                itemBuilder: (context, index) {
                  return Container(
                    color: Colors.white,
                    padding: EdgeInsets.symmetric(horizontal: 20, vertical: 20),
                    child: Column(
                      children: [
                        InkWell(
                          onTap: () {
                            Get.to(() => OrderDetails(
                                  order: cancelledController
                                      .cancelledOrderListModel
                                      .value
                                      .orders![index],
                                ));
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    children: [
                                      Text(
                                        cancelledController
                                            .cancelledOrderListModel
                                            .value
                                            .orders![index]
                                            .orderNumber!
                                            .capitalizeFirst!,
                                        style: AppStyles.kFontBlack15w4,
                                      ),
                                      Icon(
                                        Icons.arrow_forward_ios,
                                        size: 15.w,
                                        color: AppStyles.blackColor,
                                      ),
                                    ],
                                  ),
                                  SizedBox(
                                    height: 5.2.h,
                                  ),
                                  Text(
                                    'Placed on'.tr +
                                        ': ' +
                                        cancelledController
                                            .cancelledOrderListModel
                                            .value
                                            .orders![index]
                                            .createdAt!
                                            .toLocal()
                                            .toString(),
                                    style: AppStyles.kFontBlack12w4,
                                  ),
                                  SizedBox(
                                    height: 5.2.h,
                                  ),
                                ],
                              ),
                              Expanded(child: Container()),
                              Text(
                                '${orderStatusGet(cancelledController.cancelledOrderListModel.value.orders![index])}',
                                style: AppStyles.kFontBlack12w4,
                              ),
                            ],
                          ),
                        ),
                        SizedBox(
                          height: 10.h,
                        ),
                        ListView.builder(
                            shrinkWrap: true,
                            physics: NeverScrollableScrollPhysics(),
                            itemCount: cancelledController
                                .cancelledOrderListModel
                                .value
                                .orders![index]
                                .packages!
                                .length,
                            itemBuilder: (context, packageIndex) {
                              return Container(
                                padding: EdgeInsets.symmetric(vertical: 10),
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Column(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Row(
                                                children: [
                                                  Image.asset(
                                                    'assets/images/icon_delivery-parcel.png',
                                                    width: 17.w,
                                                    height: 17.w,
                                                  ),
                                                  SizedBox(
                                                    width: 8.w,
                                                  ),
                                                  Text(
                                                    cancelledController
                                                        .cancelledOrderListModel
                                                        .value
                                                        .orders![index]
                                                        .packages![packageIndex]
                                                        .packageCode!,
                                                    style: AppStyles
                                                        .kFontBlack14w5,
                                                  ),
                                                ],
                                              ),
                                              Padding(
                                                padding: EdgeInsets.only(
                                                    left: 26.0, top: 5),
                                                child: Text(
                                                  'Sold by'.tr +
                                                      ': ' +
                                                      cancelledController
                                                          .cancelledOrderListModel
                                                          .value
                                                          .orders![index]
                                                          .packages![
                                                              packageIndex]
                                                          .seller!
                                                          .firstName!,
                                                  style:
                                                      AppStyles.kFontBlack14w5,
                                                ),
                                              ),
                                              Padding(
                                                padding: EdgeInsets.only(
                                                    left: 26.0, top: 5),
                                                child: Text(
                                                  cancelledController
                                                      .cancelledOrderListModel
                                                      .value
                                                      .orders![index]
                                                      .packages![packageIndex]
                                                      .shippingDate ?? '',
                                                  style:
                                                      AppStyles.kFontBlack12w4,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                        Text(
                                          deliverStateName(cancelledController
                                              .cancelledOrderListModel
                                              .value
                                              .orders![index]
                                              .packages![packageIndex]),
                                          textAlign: TextAlign.center,
                                          style: AppStyles.kFontDarkBlue12w5
                                              .copyWith(
                                                  fontStyle: FontStyle.italic),
                                        ),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 15.h,
                                    ),
                                    ListView.separated(
                                        separatorBuilder: (context, index) {
                                          return Divider(
                                            color: AppStyles.appBackgroundColor,
                                            height: 2.h,
                                            thickness: 2,
                                          );
                                        },
                                        shrinkWrap: true,
                                        padding: EdgeInsets.only(left: 26.0),
                                        physics: NeverScrollableScrollPhysics(),
                                        itemCount: cancelledController.cancelledOrderListModel.value.orders?[index].packages?[packageIndex].products?.length ?? 0,
                                        itemBuilder: (context, productIndex) {
                                          if (cancelledController
                                                  .cancelledOrderListModel
                                                  .value
                                                  .orders![index]
                                                  .packages![packageIndex]
                                                  .products![productIndex]
                                                  .type ==
                                              ProductType.GIFT_CARD) {
                                            return Container(
                                              margin: EdgeInsets.symmetric(
                                                  vertical: 10.h),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  ClipRRect(
                                                    borderRadius:
                                                        BorderRadius.all(
                                                            Radius.circular(5.r)),
                                                    child: Container(
                                                        height: 80.w,
                                                        width: 80.w,
                                                        child: Image.network(
                                                          AppConfig.assetPath +
                                                              '/' +
                                                              cancelledController
                                                                  .cancelledOrderListModel
                                                                  .value
                                                                  .orders![index]
                                                                  .packages![
                                                                      packageIndex]
                                                                  .products![
                                                                      productIndex]
                                                                  .giftCard!
                                                                  .thumbnailImage!,
                                                          fit: BoxFit.cover,
                                                        )),
                                                  ),
                                                  SizedBox(
                                                    width: 15.w,
                                                  ),
                                                  Expanded(
                                                    child: Container(
                                                      child: Column(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .start,
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            cancelledController
                                                                .cancelledOrderListModel
                                                                .value
                                                                .orders![index]
                                                                .packages![
                                                                    packageIndex]
                                                                .products![
                                                                    productIndex]
                                                                .giftCard!
                                                                .name!,
                                                            style: AppStyles
                                                                .kFontBlack14w5,
                                                          ),
                                                          SizedBox(
                                                            height: 5.h,
                                                          ),
                                                          Row(
                                                            mainAxisAlignment:
                                                                MainAxisAlignment
                                                                    .spaceAround,
                                                            children: [
                                                              Text(
                                                                '${(cancelledController.cancelledOrderListModel.value.orders![index].packages![packageIndex].products![productIndex].giftCard!.sellingPrice! * _currencyController.conversionRate.value).toString()}${_currencyController.appCurrency.value}',
                                                                style: AppStyles
                                                                    .kFontPink15w5,
                                                              ),
                                                              Expanded(
                                                                child:
                                                                    Container(),
                                                              ),
                                                            ],
                                                          ),
                                                          SizedBox(
                                                            height: 5.h,
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          } else {
                                            return Container(
                                              margin: EdgeInsets.symmetric(
                                                  vertical: 10.h),
                                              child: Row(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  ClipRRect(
                                                    borderRadius:
                                                        BorderRadius.all(
                                                            Radius.circular(5.r)),
                                                    child: Container(
                                                        height: 80.w,
                                                        width: 80.w,
                                                        child: Image.network(
                                                          AppConfig.assetPath +
                                                              '/' +
                                                              cancelledController
                                                                  .cancelledOrderListModel
                                                                  .value
                                                                  .orders![index]
                                                                  .packages![
                                                                      packageIndex]
                                                                  .products![
                                                                      productIndex]
                                                                  .sellerProductSku!
                                                                  .product!
                                                                  .product!
                                                                  .thumbnailImageSource!,
                                                          fit: BoxFit.cover,
                                                        )),
                                                  ),
                                                  SizedBox(
                                                    width: 15.w,
                                                  ),
                                                  Expanded(
                                                    child: Container(
                                                      child: Column(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .start,
                                                        crossAxisAlignment:
                                                            CrossAxisAlignment
                                                                .start,
                                                        children: [
                                                          Text(
                                                            cancelledController
                                                                .cancelledOrderListModel
                                                                .value
                                                                .orders![index]
                                                                .packages![
                                                                    packageIndex]
                                                                .products![
                                                                    productIndex]
                                                                .sellerProductSku!
                                                                .product!
                                                                .productName!,
                                                            style: AppStyles
                                                                .kFontBlack14w5,
                                                          ),
                                                          ListView.builder(
                                                            shrinkWrap: true,
                                                            physics:
                                                                NeverScrollableScrollPhysics(),
                                                            itemCount: cancelledController.cancelledOrderListModel.value.orders?[index].packages![packageIndex].products?[productIndex].sellerProductSku?.productVariations?.length??0,

                                                            itemBuilder: (context,
                                                                variantIndex) {

                                                              var attributeValue = cancelledController.cancelledOrderListModel.value.orders?[index].packages?[packageIndex].products?[productIndex].sellerProductSku?.productVariations?[variantIndex].attributeValue;
                                                              var attribute = cancelledController.cancelledOrderListModel.value.orders?[index].packages?[packageIndex].products?[productIndex].sellerProductSku?.productVariations?[variantIndex].attribute;

                                                              log("attributeValue :::${attributeValue?.toJson()}");

                                                                return Text(
                                                                  '${attribute?.name??''}: ${attributeValue?.name??attributeValue?.value??''}',
                                                                  style: AppStyles
                                                                      .kFontBlack12w4,
                                                                );

                                                            },
                                                          ),
                                                          SizedBox(
                                                            height: 5.h,
                                                          ),
                                                          Row(
                                                            mainAxisAlignment:
                                                                MainAxisAlignment
                                                                    .spaceAround,
                                                            children: [
                                                              Column(
                                                                mainAxisAlignment:
                                                                    MainAxisAlignment
                                                                        .start,
                                                                crossAxisAlignment:
                                                                    CrossAxisAlignment
                                                                        .start,
                                                                children: [
                                                                  Row(
                                                                    mainAxisAlignment:
                                                                        MainAxisAlignment
                                                                            .start,
                                                                    crossAxisAlignment:
                                                                        CrossAxisAlignment
                                                                            .start,
                                                                    children: [
                                                                      Text(
                                                                        '${_currencyController.appCurrency.value}${((cancelledController.cancelledOrderListModel.value.orders![index].packages![packageIndex].products![productIndex].price??0) * _currencyController.conversionRate.value).toStringAsFixed(AppUtilities.getDecimalLimit())}',
                                                                        style: AppStyles
                                                                            .kFontPink15w5,
                                                                      ),
                                                                      SizedBox(
                                                                        width:
                                                                            5.w,
                                                                      ),
                                                                      Text(
                                                                        '(${cancelledController.cancelledOrderListModel.value.orders![index].packages![packageIndex].products![productIndex].qty}x)',
                                                                        style: AppStyles
                                                                            .kFontBlack14w5,
                                                                      ),
                                                                    ],
                                                                  ),
                                                                ],
                                                              ),
                                                              Expanded(
                                                                child:
                                                                    Container(),
                                                              ),
                                                              // Text(
                                                              //   '=\$${orderController.orderListModel.value.orders[index].packages[packageIndex].products[productIndex].totalPrice}',
                                                              //   style: AppStyles
                                                              //       .kFontBlack14w5,
                                                              // ),
                                                            ],
                                                          ),
                                                          SizedBox(
                                                            height: 5.h,
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            );
                                          }
                                        }),
                                  ],
                                ),
                              );
                            }),
                        SizedBox(
                          height: 10.h,
                        ),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.end,
                          crossAxisAlignment: CrossAxisAlignment.end,
                          children: [
                            Text(
                              '${cancelledController.cancelledOrderListModel.value.orders![index].packages!.length} ' +
                                  'Package'.tr +
                                  ',' +
                                  'Total'.tr +
                                  ':' +
                                  '${_currencyController.appCurrency.value}' +
                                  (cancelledController.cancelledOrderListModel
                                              .value.orders![index].grandTotal! *
                                          _currencyController
                                              .conversionRate.value)
                                      .toStringAsFixed(AppUtilities.getDecimalLimit()),
                              style: AppStyles.kFontBlack14w5,
                            ),
                          ],
                        ),
                      ],
                    ),
                  );
                },
              ),
            );
          }
        },
      ),
    );
  }
}
